/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.SaleReturn;
import com.backend.Service.SaleReturnService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sale-return"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class SaleReturnController {
    @Autowired
    private SaleReturnService saleReturnService;

    @PostMapping(value={"/save"})
    public ResponseEntity<SaleReturn> createSaleReturn(@RequestBody SaleReturn saleReturn) {
        SaleReturn savedSaleReturn = this.saleReturnService.saveSaleReturn(saleReturn);
        return new ResponseEntity((Object)savedSaleReturn, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<SaleReturn>> getAllSaleReturns() {
        List returns = this.saleReturnService.getAllSaleReturns();
        return new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<SaleReturn>> getSaleReturnById(@PathVariable Long id) {
        Optional returns = this.saleReturnService.getSaleReturnById(id);
        return returns.isPresent() ? new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<SaleReturn> updateSaleReturn(@PathVariable Long id, @RequestBody SaleReturn saleReturn) {
        SaleReturn updatedSaleReturn = this.saleReturnService.updateSaleReturn(id, saleReturn);
        return updatedSaleReturn != null ? new ResponseEntity((Object)updatedSaleReturn, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteSaleReturn(@PathVariable Long id) {
        this.saleReturnService.deleteSaleReturn(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllReturnIds"})
    public ResponseEntity<List<String>> getAllReturnIds() {
        List returnIds = this.saleReturnService.getAllReturnIds();
        return new ResponseEntity((Object)returnIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getByPRId/{id}"})
    public ResponseEntity<SaleReturn> getSaleReturnByPRId(@PathVariable String id) {
        Optional saleReturn = this.saleReturnService.getSaleReturnByPRId(id);
        return saleReturn.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getReturnIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getSaleReturnIdsByStatus(@PathVariable Long status) {
        List saleReturnIds = this.saleReturnService.getSaleReturnIdsByStatus(status);
        return new ResponseEntity((Object)saleReturnIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<SaleReturn> updateSaleReturnStatus(@PathVariable Long id, @RequestBody SaleReturn updatedSaleReturn) {
        Optional existingSaleReturn = this.saleReturnService.getSaleReturnById(id);
        if (existingSaleReturn.isPresent()) {
            SaleReturn saleReturn = (SaleReturn)existingSaleReturn.get();
            saleReturn.setStatus(updatedSaleReturn.getStatus());
            SaleReturn updatedReturn = this.saleReturnService.saveSaleReturn(saleReturn);
            return new ResponseEntity((Object)updatedReturn, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingReturns"})
    public ResponseEntity<List<SaleReturn>> getPendingReturns() {
        List pendingReturns = this.saleReturnService.getPendingOrders();
        return new ResponseEntity((Object)pendingReturns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedReturns"})
    public ResponseEntity<List<SaleReturn>> getAcceptedReturns() {
        List acceptedReturns = this.saleReturnService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedReturns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedReturns"})
    public ResponseEntity<List<SaleReturn>> getRejectedReturns() {
        List rejectedReturns = this.saleReturnService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedReturns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipReturns"})
    public ResponseEntity<List<SaleReturn>> getShipReturns() {
        List shipReturns = this.saleReturnService.getShipOrders();
        return new ResponseEntity((Object)shipReturns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{saleReturnId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String saleReturnId) {
        Long totalShippedItems = this.saleReturnService.getTotalShippedItems(saleReturnId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }
}

