/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.PurchaseOrder;
import com.backend.Entity.PurchaseReturn;
import com.backend.Service.PurchaseReturnService;
import com.backend.Util.FileUploadUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/purchase-return"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PurchaseReturnController {
    @Autowired
    private PurchaseReturnService purchaseReturnService;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseReturn> createPurchase(@RequestParam(value="purchaseReturn") String purchaseReturnJson, @RequestParam(value="receipt", required=false) MultipartFile receiptFile) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseReturn purchaseReturn = (PurchaseReturn)objectMapper.readValue(purchaseReturnJson, PurchaseReturn.class);
            if (receiptFile != null && !receiptFile.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + receiptFile.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, receiptFile);
                purchaseReturn.setReceipt(filePath);
            }
            PurchaseReturn savedPurchaseReturn = this.purchaseReturnService.savePurchaseReturn(purchaseReturn);
            return new ResponseEntity((Object)savedPurchaseReturn, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseReturn> updatePurchaseReturn(@PathVariable Long id, @RequestParam(value="purchaseReturn") String purchaseReturnJson, @RequestParam(value="receipt", required=false) MultipartFile receiptFile) {
        try {
            Optional existingOpt = this.purchaseReturnService.getPurchaseReturnById(id);
            if (!existingOpt.isPresent()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            PurchaseReturn existingOrder = (PurchaseReturn)existingOpt.get();
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseReturn updatedOrder = (PurchaseReturn)objectMapper.readValue(purchaseReturnJson, PurchaseReturn.class);
            updatedOrder.setId(id);
            if (receiptFile != null && !receiptFile.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + receiptFile.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, receiptFile);
                updatedOrder.setReceipt(filePath);
            } else {
                updatedOrder.setReceipt(existingOrder.getReceipt());
            }
            PurchaseReturn saved = this.purchaseReturnService.updatePurchaseReturn(id, updatedOrder);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseReturn>> getAllPurchaseReturns() {
        List returns = this.purchaseReturnService.getAllPurchaseReturns();
        return new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseReturn>> getPurchaseOrderById(@PathVariable Long id) {
        Optional returns = this.purchaseReturnService.getPurchaseReturnById(id);
        return returns.isPresent() ? new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseReturnService.deletePurchaseReturn(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllReturnIds() {
        List returnIds = this.purchaseReturnService.getAllReturnIds();
        return new ResponseEntity((Object)returnIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<PurchaseReturn> getPurchaseOrderByPoId(@PathVariable String id) {
        Optional order = this.purchaseReturnService.getPurchaseReturnByPRId(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getOrderIdsByStatus(@PathVariable Long status) {
        List orderIds = this.purchaseReturnService.getPurchaseReturnIdsByStatus(status);
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<PurchaseReturn> updatePurchaseStatus(@PathVariable Long id, @RequestBody PurchaseOrder updatedStatus) {
        Optional existingOrder = this.purchaseReturnService.getPurchaseReturnById(id);
        if (existingOrder.isPresent()) {
            PurchaseReturn purchaseReturn = (PurchaseReturn)existingOrder.get();
            purchaseReturn.setStatus(updatedStatus.getStatus());
            PurchaseReturn updatedOrder = this.purchaseReturnService.savePurchaseReturn(purchaseReturn);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<PurchaseReturn>> getPendingOrders() {
        List pendingOrders = this.purchaseReturnService.getPendingOrders();
        return new ResponseEntity((Object)pendingOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<PurchaseReturn>> getAcceptedOrders() {
        List acceptedOrders = this.purchaseReturnService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<PurchaseReturn>> getRejectedOrders() {
        List rejectedOrders = this.purchaseReturnService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<PurchaseReturn>> getShipOrders() {
        List shipOrders = this.purchaseReturnService.getShipOrders();
        return new ResponseEntity((Object)shipOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getFinalOrders"})
    public ResponseEntity<List<PurchaseReturn>> getFinalOrders() {
        List finalOrders = this.purchaseReturnService.getReturnedOrders();
        return new ResponseEntity((Object)finalOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{purchaseOrderId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String purchaseReturnId) {
        Long totalShippedItems = this.purchaseReturnService.getTotalShippedItems(purchaseReturnId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }

    @PutMapping(value={"/updatePaymentStatus/{id}"})
    public ResponseEntity<PurchaseReturn> updatePaymentStatus(@PathVariable Long id, @RequestBody PurchaseReturn updatedData) {
        Optional optionalPurchaseReturn = this.purchaseReturnService.getPurchaseReturnById(id);
        if (optionalPurchaseReturn.isPresent()) {
            PurchaseReturn existingReturn = (PurchaseReturn)optionalPurchaseReturn.get();
            existingReturn.setPaymentStatus(updatedData.getPaymentStatus());
            PurchaseReturn savedReturn = this.purchaseReturnService.savePurchaseReturn(existingReturn);
            return ResponseEntity.ok((Object)savedReturn);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
    }
}

