/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.PayRoll;
import com.backend.Service.PayRollService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payroll"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PayRollController {
    @Autowired
    private PayRollService payRollService;

    @PostMapping(value={"/add"})
    public ResponseEntity<PayRoll> savePayRoll(@RequestBody PayRoll payRoll) {
        PayRoll savedPayRoll = this.payRollService.savePayRoll(payRoll);
        return new ResponseEntity((Object)savedPayRoll, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PayRoll>> getAllPayRolls() {
        List payRolls = this.payRollService.getAllPayRolls();
        return new ResponseEntity((Object)payRolls, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<PayRoll> getPayRollById(@PathVariable Long id) {
        PayRoll payRoll = this.payRollService.getPayRollById(id);
        if (payRoll != null) {
            return new ResponseEntity((Object)payRoll, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PayRoll> updatePayRoll(@PathVariable Long id, @RequestBody PayRoll updatedPayRoll) {
        PayRoll updated = this.payRollService.updatePayRoll(id, updatedPayRoll);
        if (updated != null) {
            return new ResponseEntity((Object)updated, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePayRoll(@PathVariable Long id) {
        this.payRollService.deletePayRollById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

