/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.PayComponent;
import com.backend.Service.PayComponentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay-component"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PayComponentController {
    @Autowired
    private PayComponentService payComponentService;

    @GetMapping(value={"/all"})
    public ResponseEntity<List<PayComponent>> getAllPayComponents() {
        List payComponents = this.payComponentService.getAllPayComponents();
        return new ResponseEntity((Object)payComponents, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PayComponent> getPayComponentById(@PathVariable Long id) {
        PayComponent payComponent = this.payComponentService.getPayComponentById(id);
        if (payComponent != null) {
            return new ResponseEntity((Object)payComponent, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<PayComponent> savePayComponent(@RequestBody PayComponent payComponent) {
        PayComponent savedPayComponent = this.payComponentService.savePayComponent(payComponent);
        return new ResponseEntity((Object)savedPayComponent, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PayComponent> updatePayComponent(@PathVariable Long id, @RequestBody PayComponent updatedPayComponent) {
        PayComponent updated = this.payComponentService.updatePayComponent(id, updatedPayComponent);
        if (updated != null) {
            return new ResponseEntity((Object)updated, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePayComponent(@PathVariable Long id) {
        this.payComponentService.deletePayComponentById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

