/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Lead;
import com.backend.Service.LeadService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lead"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class LeadController {
    @Autowired
    private LeadService leadService;

    @PostMapping(value={"/save"})
    public Lead saveLead(@RequestBody Lead lead) {
        return this.leadService.saveLead(lead);
    }

    @GetMapping(value={"/getall"})
    public List<Lead> getAllLeads() {
        return this.leadService.getAllLeads();
    }

    @GetMapping(value={"/get/{id}"})
    public Lead getLeadById(@PathVariable Long id) {
        return this.leadService.getLeadById(id);
    }

    @PutMapping(value={"/update/{id}"})
    public Lead updateLead(@PathVariable Long id, @RequestBody Lead updatedLead) {
        return this.leadService.updateLead(id, updatedLead);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public void deleteLead(@PathVariable Long id) {
        this.leadService.deleteLeadById(id);
    }
}

